( function() {
    const settings = window.wc && window.wc.wcSettings ? window.wc.wcSettings.getSetting( 'swiftcash_gateway_data', {} ) : {};
    const { __ } = window.wp && window.wp.i18n ? window.wp.i18n : { __: (s) => s };

    const Label = ( props ) => {
        const text = settings && settings.title ? settings.title : 'SwiftCash';
        return wp.element.createElement( 'span', null, text );
    };

    const Content = ( props ) => {
        const text = (settings && settings.description) ? settings.description : '';
        return text ? wp.element.createElement( 'div', { className: 'wc-block-payment-method__description' }, text ) : null;
    };

    const canMakePayment = () => true;

    if ( window.wc && window.wc.wcBlocksRegistry && window.wc.wcBlocksRegistry.registerPaymentMethod ) {
        window.wc.wcBlocksRegistry.registerPaymentMethod( {
            name: 'swiftcash_gateway',
            label: Label,
            content: Content,
            edit: Content,
            canMakePayment,
            ariaLabel: 'SwiftCash',
            paymentMethodId: 'swiftcash_gateway',
            supports: { features: [] },
        } );
    }
} )();
