<?php
/**
 * Plugin Name: SwiftCash – WooCommerce Gateway (Blocks + Classic)
 * Plugin URI: https://swiftcash.app/
 * Description: SwiftCash payment gateway for WooCommerce. Supports classic checkout and the new Cart & Checkout Blocks. Initiates payment via SwiftCash API and redirects the shopper to the hosted checkout URL. Verifies IPN to complete orders.
 * Author: PayMealApp
 * Author URI: https://github.com/PayMealApp
 * Version: 2.0.0
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * WC requires at least: 8.0
 * WC tested up to: 10.1
 * Text Domain: swiftcash
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

define( 'SWIFTCASH_PLUGIN_VERSION', '2.0.0' );
define( 'SWIFTCASH_PLUGIN_FILE', __FILE__ );
define( 'SWIFTCASH_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'SWIFTCASH_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * Declare compatibility with WooCommerce features (Blocks + HPOS).
 */
add_action( 'before_woocommerce_init', function () {
    if ( class_exists( '\\Automattic\\WooCommerce\\Utilities\\FeaturesUtil' ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
    }
} );

/**
 * Ensure WooCommerce is active.
 */
add_action( 'plugins_loaded', function () {
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', function () {
            echo '<div class="notice notice-error"><p>' . esc_html__( 'SwiftCash requires WooCommerce to be installed and active.', 'swiftcash' ) . '</p></div>';
        } );
    }
}, 1 );

/**
 * Load classes and register gateway (classic checkout).
 */
add_action( 'plugins_loaded', function () {
    if ( ! class_exists( 'WooCommerce' ) ) { return; }
    require_once SWIFTCASH_PLUGIN_DIR . 'includes/class-wc-gateway-swiftcash.php';
    require_once SWIFTCASH_PLUGIN_DIR . 'includes/class-swiftcash-webhook.php';
    add_filter( 'woocommerce_payment_gateways', function ( $methods ) {
        $methods[] = 'WC_Gateway_SwiftCash';
        return $methods;
    } );
}, 20 );

/**
 * Register Blocks integration via official hook.
 */
add_action(
    'woocommerce_blocks_payment_method_type_registration',
    function ( $payment_method_registry ) {
        if ( ! class_exists( '\\Automattic\\WooCommerce\\Blocks\\Payments\\Integrations\\AbstractPaymentMethodType' ) ) { return; }
        require_once SWIFTCASH_PLUGIN_DIR . 'includes/class-wc-gateway-swiftcash-blocks.php';
        if ( class_exists( 'WC_Gateway_SwiftCash_Blocks' ) ) {
            $payment_method_registry->register( new \WC_Gateway_SwiftCash_Blocks() );
        }
    }
);

/**
 * Register REST route for SwiftCash IPN.
 */
add_action( 'rest_api_init', function () {
    \SwiftCash_Webhook::register_routes();
} );
